#delimit ;
clear;
set mem 300m;
* set this to 1 if include 2020 wave;
global INCLUDE2020 1;
*global folder "C:\research";
*global folder "C:\Users\Jeremy\Dropbox";
*global folder "\\econ-san-fs\Home4\uctpkp0\SystemFolder\Windows7\Desktop";
*global folder "\\ad.ucl.ac.uk\homer\zctpmer\downloads";
global folder "D:\Dropbox";

         local saved  "$folder\hrs\merge\";
         local trackd "$folder\hrs\tracker\";
         local wave1d "$folder\hrs\wave1\";
         local wave2d "$folder\hrs\wave2\";
         local wave3d "$folder\hrs\wave3\";
         local wave4d "$folder\hrs\wave4\";
         local wave5d "$folder\hrs\wave5\";
		 local wave6d "$folder\hrs\wave6\";
         local wave7d "$folder\hrs\wave7\";
         local wave8d "$folder\hrs\wave8\";
		 local wave9d "$folder\hrs\wave9\";
		 local wave10d "$folder\hrs\wave10\";
		 local wave11d "$folder\hrs\wave11\";
		 local wave12d "$folder\hrs\wave12\";
		 local wave13d "$folder\hrs\wave13\";
	 	 local wave14d "$folder\hrs\wave14\";
		 local wave15d "$folder\hrs\wave15\";
         local aheadw1 "$folder\hrs\aheadw1\";
         local aheadw2 "$folder\hrs\aheadw2\";

*log using `saved'settle.log, replace;



*********************************** WAVE I ***************************;
******** no information available about unsettlement for wave 1 **********;

clear;
set mem 200m;
use `wave1d'househld;

gen unset1=.;
rename APN_FIN PN;
gen temp=real(HHID); 
drop HHID; 
rename temp HHID; 
gen temp=real(PN); 
drop PN; 
rename temp PN; 
sort HHID PN; 

keep HHID PN unset1;
sort HHID PN;
sleep 1000; save `saved'settle, replace;





********************************** WAVE 2 ****************************;
clear;
set mem 200m;
use `wave2d'w2b;
gen unset2=.;
* note: in the following re-coding: 2 means true missing;



* about cost of hospital stay;
replace unset2=0  if W410==5|W410==9; * No and DK for hospital stay;
replace unset2=2 if W410==9;
replace unset2=2 if W411==998|W411==999;
replace unset2=0 if W414>0 & W414<6;
replace unset2=1 if W414==6; * free or did not pay, including the cases: free clinic, a friend is a doctor, could not pay, still owe;
**** Li's suggestion?????: lack of accuracy here because we can't differentiate further. I suppose most of the cases are when people can't pay or don't have insurance;
replace unset2=0 if W414==7; *  other cases;
replace unset2=2 if unset2~=1 & unset2~=0 & W414>7; * DK and RF;

* about cost of nursing home stay;
replace unset2=0 if unset2~=1 & unset2~=2 & (W415==5|W415==8);
replace unset2=2 if unset2~=1 & W415==9;
replace unset2=2 if unset2~=1 & (W416==998|W416==999);
replace unset2=0 if unset2~=1 &  unset2~=2 & W419>0 & W419<6;
replace unset2=1 if W419==6;
replace unset2=0 if unset2~=1 &  unset2~=2 & W419==7;
replace unset2=2 if unset2~=1 & W419>7; 


* about doctor's visits;
replace unset2=2 if unset2~=1 & W420>997; * DK and RF;
replace unset2=0 if unset2~=1 &  unset2~=2 & W421>0 & W421<6;
replace unset2=1 if W421==6;
replace unset2=0 if unset2~=1 &  unset2~=2 & W421==7;
replace unset2=2 if unset2~=1 & W421>7; 

* for prescribed medications; 
replace unset2=0 if unset2~=1 & unset2~=2 & (W433==5|W433==8);
replace unset2=2 if unset2~=1 & W433==9;
replace unset2=2 if unset2~=2 & (W434==99998|W434==99999);
replace unset2=0 if unset2~=1 &  unset2~=2 & W436>0 & W436<6;
replace unset2=1 if W436==6;
replace unset2=0 if unset2~=1 &  unset2~=2 & W436==7;
replace unset2=2 if unset2~=1 & W436>7; 

* convert 2 into missing;
replace unset2=. if unset2==2; 

gen temp=real(HHID); 
drop HHID; 
rename temp HHID; 
gen temp=real(PN); 
drop PN; 
rename temp PN; 
sort HHID PN; 

keep HHID PN unset2;
summ;



sort HHID PN;
merge HHID PN using `saved'settle; 
drop _merge;

sort HHID PN; 
sleep 1000; save `saved'settle, replace;
drop _all;




************************************* wave 3 ********************;

use `wave3d'h96cs_r; * get CS11 from this file;
keep HHID PN E240;
sort HHID PN;
sleep 1000; save `saved'temp, replace;

clear;
use `wave3d'h96e_r;
sort HHID PN;
merge HHID PN using `saved'temp;
drop _merge;

gen temp=real(HHID);
drop HHID;
rename temp HHID;
gen temp=real(PN);
drop PN;
rename temp PN;


********************************************;
gen unset3=.;
* note: in the following re-coding, 2 is meant for known MISSING values;



* for hospital stay;
replace unset3=0 if E1770==5|E1770==8; * No hospital stay or DK;
replace unset3=2 if E1770==9; * RF;
replace unset3=0 if unset3~=2 & (E1775==1|E1775==3|E1775==5);
replace unset3=1 if E1775==7;
replace unset3=2 if unset3~=1 & unset3~=0 & (E1775==8|E1775==9);



* for nursing home stay;
replace unset3=0 if unset3~=1 &  unset3~=2 & (E1776==5|E1776==8); 
replace unset3=2 if unset3~=1 & E1776==9;
replace unset3=0 if unset3~=1 & unset3~=2 & (E1781==1|E1781==3|E1781==5);
replace unset3=1 if E1781==7;
replace unset3=2 if unset3~=1 & (E1781==8|E1781==9);

* for doctor's visits;
replace unset3=0 if unset3~=1 & unset3~=2 & E1790==0; 
replace unset3=2 if unset3~=1 & (E1790==998|E1790==999);
replace unset3=0 if unset3~=1 & unset3~=2 & (E1793==1|E1793==3|E1793==5);
replace unset3=1 if E1793==7;
replace unset3=2 if unset3~=1 & (E1793==8|E1793==9);
 
* for outpatient surgery;
replace unset3=0 if unset3~=1 & unset3~=2 & (E1795==5|E1795==8); 
replace unset3=2 if unset3~=1 & E1795==9;
replace unset3=0 if unset3~=1 & unset3~=2 & (E1798==1|E1798==3|E1798==5);
replace unset3=1 if E1798==7;
replace unset3=2 if unset3~=1 & (E1798==8|E1798==9);


* for dental care;
replace unset3=0 if unset3~=1 & unset3~=2 & (E1800==5|E1800==8); 
replace unset3=2 if unset3~=1 & E1800==9;
replace unset3=0 if unset3~=1 & unset3~=2 & (E1803==1|E1803==3|E1803==5);
replace unset3=1 if E1803==7;
replace unset3=2 if unset3~=1 & (E1803==8|E1803==9);


* for prescription medications;
replace unset3=0 if unset3~=1 & unset3~=2 & (E1811==5|E1811==8); 
replace unset3=2 if unset3~=1 & E1811==9;
replace unset3=0 if unset3~=1 & unset3~=2 & (E1815==1|E1815==3|E1815==5);
replace unset3=1 if E1815==7;
replace unset3=2 if unset3~=1 & (E1815==8|E1815==9);

* for home medical care;
replace unset3=0 if unset3~=1 & unset3~=2 & E240==1; * stay in nursing home;
replace unset3=0 if unset3~=1 & unset3~=2 & (E1827==5|E1827==8); 
replace unset3=2 if unset3~=1 & E1827==9;
replace unset3=0 if unset3~=1 & unset3~=2 & (E1829==1|E1829==3|E1829==5);
replace unset3=1 if E1829==7;
replace unset3=2 if unset3~=1 & (E1829==8|E1829==9);

replace unset3=. if unset3==2;

keep HHID PN unset3;
summ;

sort HHID PN;
merge HHID PN using `saved'settle; 
drop _merge;

sort HHID PN; 
sleep 1000; save `saved'settle, replace;
drop _all;



*********************************** wave 4 *****************************;


* use `wave4d'H98pr_r; *This used to be Hrs98pr;
use `wave4d'h98cs_r; * we should use the updated file;
keep F517 HHID PN;
sort HHID PN;
sleep 1000; save `saved'temp, replace;


* use `wave4d'hrs98e;
use `wave4d'h98e_r; * we should use the updated file;

sort HHID PN;
merge HHID PN using `saved'temp;
drop _merge;

gen temp=real(HHID);
drop HHID;
rename temp HHID;
gen temp = real(PN);
drop PN;
rename temp PN;
sort HHID PN;



***************************************;

gen unset4=.;
* note: in the following re-coding, 2 is meant for known missing;

* for hospital stay;
replace unset4=0 if F2295==5|F2295==8;
replace unset4=2 if F2295==9;
replace unset4=0 if F2298==1|F2298==3|F2298==5;
replace unset4=1 if F2298==7;
replace unset4=2 if F2298==8|F2298==9;


* for nursing home stay;
replace unset4=0 if unset4~=1 &  unset4~=2 & (F2299==5|F2299==8); 
replace unset4=2 if unset4~=1 & F2299==9;
replace unset4=0 if unset4~=1 & unset4~=2 & (F2304==1|F2304==3|F2304==5);
replace unset4=1 if F2304==7;
replace unset4=2 if unset4~=1 & (F2304==8|F2304==9);



* for doctor visits;
replace unset4=0 if unset4~=1 &  unset4~=2 & F2331==0; 
replace unset4=0 if unset4~=1 & unset4~=2 & (F2332==1|F2332==3|F2332==5);
replace unset4=1 if F2332==7;
replace unset4=2 if unset4~=1 & (F2332==8|F2332==9);


* for outpatient surgery;
replace unset4=0 if unset4~=1 &  unset4~=2 & (F2333==5|F2333==8); 
replace unset4=2 if unset4~=1 & F2333==9;
replace unset4=0 if unset4~=1 & unset4~=2 & (F2334==1|F2334==3|F2334==5);
replace unset4=1 if F2334==7;
replace unset4=2 if unset4~=1 & (F2334==8|F2334==9);


* for dental care;
replace unset4=0 if unset4~=1 &  unset4~=2 & (F2335==5|F2335==8); 
replace unset4=2 if unset4~=1 & F2335==9;
replace unset4=0 if unset4~=1 & unset4~=2 & (F2336==1|F2336==3|F2336==5);
replace unset4=1 if F2336==7;
replace unset4=2 if unset4~=1 & (F2336==8|F2336==9);

* for prescription medications;
replace unset4=0 if unset4~=1 &  unset4~=2 & (F2345==5|F2345==8); 
replace unset4=2 if unset4~=1 & F2345==9;
replace unset4=0 if unset4~=1 & unset4~=2 & (F2346==1|F2346==3|F2346==5);
replace unset4=1 if F2346==7;
replace unset4=2 if unset4~=1 & (F2346==8|F2346==9);

* for home medical care;
replace unset4=0 if unset4~=1 &  unset4~=2 & F517==1; * living in nursing home;
replace unset4=0 if unset4~=1 &  unset4~=2 & (F2357==5|F2357==8); 
replace unset4=2 if unset4~=1 & F2357==9;
replace unset4=0 if unset4~=1 & unset4~=2 & (F2359==1|F2359==3|F2359==5);
replace unset4=1 if F2359==7;
replace unset4=2 if unset4~=1 & (F2359==8|F2359==9);


replace unset4=. if unset4==2;


keep HHID PN unset4;
summ;

sort HHID PN;
merge HHID PN using `saved'settle; 
drop _merge;

sort HHID PN; 
sleep 1000; save `saved'settle, replace;
drop _all;


******************************* wave 5 *********************;

use `wave5d'H00CS_R;
keep G558 HHID PN;
sort HHID PN;
sleep 1000; save `saved'temp, replace;

clear;
use `wave5d'H00E_R;
sort HHID PN;
merge HHID PN using `saved'temp;
drop _merge;

gen temp=real(HHID);
drop HHID;
rename temp HHID;
gen temp=real(PN);
drop PN;
rename temp PN;


*****************************;
gen unset5=.;
* note: in the following re-coding, 2 is meant for known missing;


* for hospital stay;
replace unset5=0 if G2567==5|G2567==8;
replace unset5=2 if G2567==9;
replace unset5=0 if G2570==1|G2570==3|G2570==5;
replace unset5=1 if G2570==7;
replace unset5=2 if G2570==8|G2570==9;

* for nursing home stay;
replace unset5=0 if unset5~=1 &  unset5~=2 & (G2571==5|G2571==8); 
replace unset5=2 if unset5~=1 & G2571==9;
replace unset5=0 if unset5~=1 & unset5~=2 & (G2576==1|G2576==3|G2576==5);
replace unset5=1 if G2576==7;
replace unset5=2 if unset5~=1 & (G2576==8|G2576==9);

* for doctor visits;
replace unset5=0 if unset5~=1 &  unset5~=2 & G2603==0; 
replace unset5=0 if unset5~=1 & unset5~=2 & (G2609==1|G2609==3|G2609==5);
replace unset5=1 if G2609==7;
replace unset5=2 if unset5~=1 & (G2609==8|G2609==9);

* for outpatient surgery;
replace unset5=0 if unset5~=1 &  unset5~=2 & (G2610==5|G2610==8); 
replace unset5=2 if unset5~=1 & G2610==9;
replace unset5=0 if unset5~=1 & unset5~=2 & (G2611==1|G2611==3|G2611==5);
replace unset5=1 if G2611==7;
replace unset5=2 if unset5~=1 & (G2611==8|G2611==9);


* for dental care;
replace unset5=0 if unset5~=1 &  unset5~=2 & (G2612==5|G2612==8); 
replace unset5=2 if unset5~=1 & G2612==9;
replace unset5=0 if unset5~=1 & unset5~=2 & (G2613==1|G2613==3|G2613==5);
replace unset5=1 if G2613==7;
replace unset5=2 if unset5~=1 & (G2613==8|G2613==9);

* for prescription medications;
replace unset5=0 if unset5~=1 &  unset5~=2 & (G2622==5|G2622==8); 
replace unset5=2 if unset5~=1 & G2622==9;
replace unset5=0 if unset5~=1 & unset5~=2 & (G2623==1|G2623==3|G2623==5);
replace unset5=1 if G2623==7;
replace unset5=2 if unset5~=1 & (G2623==8|G2623==9);

* for home medical care;
replace unset5=0 if unset5~=1 &  unset5~=2 & G558==1; * living in nursing home;
replace unset5=0 if unset5~=1 &  unset5~=2 & (G2634==5|G2634==8); 
replace unset5=2 if unset5~=1 & G2634==9;
replace unset5=0 if unset5~=1 & unset5~=2 & (G2636==1|G2636==3|G2636==5);
replace unset5=1 if G2636==7;
replace unset5=2 if unset5~=1 & (G2636==8|G2636==9);

replace unset5=. if unset5==2;

keep HHID PN unset5;
summ;

sort HHID PN;
merge HHID PN using `saved'settle; 
drop _merge;

sort HHID PN; 
sleep 1000; save `saved'settle, replace;

******************************* wave 6 *********************;

use `wave6d'H02A_R;
keep HA028 HHID PN;
sort HHID PN;
sleep 1000; save `saved'temp, replace;

clear;
use `wave6d'H02N_R;
sort HHID PN;
merge HHID PN using `saved'temp;
drop _merge;

gen temp=real(HHID);
drop HHID;
rename temp HHID;
gen temp=real(PN);
drop PN;
rename temp PN;


*****************************;
gen unset6=.;
* note: in the following re-coding, 2 is meant for known missing;


* for hospital stay;
replace unset6=0 if HN099==5|HN099==8;
replace unset6=2 if HN099==9;
replace unset6=0 if HN102==1|HN102==3|HN102==5;
replace unset6=1 if HN102==7;
replace unset6=2 if HN102==8|HN102==9;

* for nursing home stay;
replace unset6=0 if unset6~=1 &  unset6~=2 & (HN114==5|HN114==8); 
replace unset6=2 if unset6~=1 & HN114==9;
replace unset6=0 if unset6~=1 & unset6~=2 & (HN118==1|HN118==3|HN118==5);
replace unset6=1 if HN118==7;
replace unset6=2 if unset6~=1 & (HN118==8|HN118==9);

* for doctor visits;
replace unset6=0 if unset6~=1 &  unset6~=2 & HN147==0; 
replace unset6=0 if unset6~=1 & unset6~=2 & (HN152==1|HN152==3|HN152==5);
replace unset6=1 if HN152==7;
replace unset6=2 if unset6~=1 & (HN152==8|HN152==9);

* for outpatient surgery;
replace unset6=0 if unset6~=1 &  unset6~=2 & (HN134==5|HN134==8); 
replace unset6=2 if unset6~=1 & HN134==9;
replace unset6=0 if unset6~=1 & unset6~=2 & (HN135==1|HN135==3|HN135==5);
replace unset6=1 if HN135==7;
replace unset6=2 if unset6~=1 & (HN135==8|HN135==9);


* for dental care;
replace unset6=0 if unset6~=1 &  unset6~=2 & (HN164==5|HN164==8); 
replace unset6=2 if unset6~=1 & HN164==9;
replace unset6=0 if unset6~=1 & unset6~=2 & (HN165==1|HN165==3|HN165==5);
replace unset6=1 if HN165==7;
replace unset6=2 if unset6~=1 & (HN165==8|HN165==9);

* for prescription medications;
replace unset6=0 if unset6~=1 &  unset6~=2 & (HN175==5|HN175==8); 
replace unset6=2 if unset6~=1 & HN175==9;
replace unset6=0 if unset6~=1 & unset6~=2 & (HN176==1|HN176==3|HN176==5);
replace unset6=1 if HN176==7;
replace unset6=2 if unset6~=1 & (HN176==8|HN176==9);

* for home medical care;
replace unset6=0 if unset6~=1 &  unset6~=2 & HA028==1; * living in nursing home;
replace unset6=0 if unset6~=1 &  unset6~=2 & (HN189==5|HN189==8); 
replace unset6=2 if unset6~=1 & HN189==9;
replace unset6=0 if unset6~=1 & unset6~=2 & (HN190==1|HN190==3|HN190==5);
replace unset6=1 if HN190==7;
replace unset6=2 if unset6~=1 & (HN190==8|HN190==9);

replace unset6=. if unset6==2;

keep HHID PN unset6;
summ;

sort HHID PN;
merge HHID PN using `saved'settle; 
drop _merge;

sort HHID PN; 
sleep 1000; save `saved'settle, replace;



******************************* wave 7 *********************;

use `wave7d'H04A_R;
keep JA028 HHID PN;
sort HHID PN;
sleep 1000; save `saved'temp, replace;

clear;
use `wave7d'H04N_R;
sort HHID PN;
merge HHID PN using `saved'temp;
drop _merge;

gen temp=real(HHID);
drop HHID;
rename temp HHID;
gen temp=real(PN);
drop PN;
rename temp PN;


*****************************;
gen unset7=.;
* note: in the following re-coding, 2 is meant for known missing;


* for hospital stay;
replace unset7=0 if JN099==5|JN099==8;
replace unset7=2 if JN099==9;
replace unset7=0 if JN102==1|JN102==3|JN102==5;
replace unset7=1 if JN102==7;
replace unset7=2 if JN102==8|JN102==9;

* for nursing home stay;
replace unset7=0 if unset7~=1 &  unset7~=2 & (JN114==5|JN114==8); 
replace unset7=2 if unset7~=1 & JN114==9;
replace unset7=0 if unset7~=1 & unset7~=2 & (JN118==1|JN118==3|JN118==5);
replace unset7=1 if JN118==7;
replace unset7=2 if unset7~=1 & (JN118==8|JN118==9);

* for doctor visits;
replace unset7=0 if unset7~=1 &  unset7~=2 & JN147==0; 
replace unset7=0 if unset7~=1 & unset7~=2 & (JN152==1|JN152==3|JN152==5);
replace unset7=1 if JN152==7;
replace unset7=2 if unset7~=1 & (JN152==8|JN152==9);

* for outpatient surgery;
replace unset7=0 if unset7~=1 &  unset7~=2 & (JN134==5|JN134==8); 
replace unset7=2 if unset7~=1 & JN134==9;
replace unset7=0 if unset7~=1 & unset7~=2 & (JN135==1|JN135==3|JN135==5);
replace unset7=1 if JN135==7;
replace unset7=2 if unset7~=1 & (JN135==8|JN135==9);


* for dental care;
replace unset7=0 if unset7~=1 &  unset7~=2 & (JN164==5|JN164==8); 
replace unset7=2 if unset7~=1 & JN164==9;
replace unset7=0 if unset7~=1 & unset7~=2 & (JN165==1|JN165==3|JN165==5);
replace unset7=1 if JN165==7;
replace unset7=2 if unset7~=1 & (JN165==8|JN165==9);

* for prescription medications;
replace unset7=0 if unset7~=1 &  unset7~=2 & (JN175==5|JN175==8); 
replace unset7=2 if unset7~=1 & JN175==9;
replace unset7=0 if unset7~=1 & unset7~=2 & (JN176==1|JN176==3|JN176==5);
replace unset7=1 if JN177==7;
replace unset7=2 if unset7~=1 & (JN176==8|JN176==9);

* for home medical care;
replace unset7=0 if unset7~=1 &  unset7~=2 & JA028==1; * living in nursing home;
replace unset7=0 if unset7~=1 &  unset7~=2 & (JN189==5|JN189==8); 
replace unset7=2 if unset7~=1 & JN189==9;
replace unset7=0 if unset7~=1 & unset7~=2 & (JN190==1|JN190==3|JN190==5);
replace unset7=1 if JN190==7;
replace unset7=2 if unset7~=1 & (JN190==8|JN190==9);

replace unset7=. if unset7==2;

keep HHID PN unset7;
summ;

sort HHID PN;
merge HHID PN using `saved'settle; 
drop _merge;

sort HHID PN; 
sleep 1000; save `saved'settle, replace;

******************************* wave 8 *********************;

use `wave8d'H06A_R;
keep KA028 HHID PN;
sort HHID PN;
sleep 1000; save `saved'temp, replace;

clear;
use `wave8d'H06N_R;
sort HHID PN;
merge HHID PN using `saved'temp;
drop _merge;

gen temp=real(HHID);
drop HHID;
rename temp HHID;
gen temp=real(PN);
drop PN;
rename temp PN;


*****************************;
gen unset8=.;
* note: in the following re-coding, 2 is meant for known missing;


* for hospital stay;
replace unset8=0 if KN099==5|KN099==8;
replace unset8=2 if KN099==9;
replace unset8=0 if KN102==1|KN102==3|KN102==5;
replace unset8=1 if KN102==7;
replace unset8=2 if KN102==8|KN102==9;

* for nursing home stay;
replace unset8=0 if unset8~=1 &  unset8~=2 & (KN114==5|KN114==8); 
replace unset8=2 if unset8~=1 & KN114==9;
replace unset8=0 if unset8~=1 & unset8~=2 & (KN118==1|KN118==3|KN118==5);
replace unset8=1 if KN118==7;
replace unset8=2 if unset8~=1 & (KN118==8|KN118==9);

* for doctor visits;
replace unset8=0 if unset8~=1 &  unset8~=2 & KN147==0; 
replace unset8=0 if unset8~=1 & unset8~=2 & (KN152==1|KN152==3|KN152==5);
replace unset8=1 if KN152==7;
replace unset8=2 if unset8~=1 & (KN152==8|KN152==9);

* for outpatient surgery;
replace unset8=0 if unset8~=1 &  unset8~=2 & (KN134==5|KN134==8); 
replace unset8=2 if unset8~=1 & KN134==9;
replace unset8=0 if unset8~=1 & unset8~=2 & (KN135==1|KN135==3|KN135==5);
replace unset8=1 if KN135==7;
replace unset8=2 if unset8~=1 & (KN135==8|KN135==9);


* for dental care;
replace unset8=0 if unset8~=1 &  unset8~=2 & (KN164==5|KN164==8); 
replace unset8=2 if unset8~=1 & KN164==9;
replace unset8=0 if unset8~=1 & unset8~=2 & (KN165==1|KN165==3|KN165==5);
replace unset8=1 if KN165==8;
replace unset8=2 if unset8~=1 & (KN165==8|KN165==9);

* for prescription medications;
replace unset8=0 if unset8~=1 &  unset8~=2 & (KN175==5|KN175==8); 
replace unset8=2 if unset8~=1 & KN175==9;
replace unset8=0 if unset8~=1 & unset8~=2 & (KN176==1|KN176==3|KN176==5);
replace unset8=1 if KN176==7;
replace unset8=2 if unset8~=1 & (KN176==8|KN176==9);

* for home medical care;
replace unset8=0 if unset8~=1 &  unset8~=2 & KA028==1; * living in nursing home;
replace unset8=0 if unset8~=1 &  unset8~=2 & (KN189==5|KN189==8); 
replace unset8=2 if unset8~=1 & KN189==9;
replace unset8=0 if unset8~=1 & unset8~=2 & (KN190==1|KN190==3|KN190==5);
replace unset8=1 if KN190==7;
replace unset8=2 if unset8~=1 & (KN190==8|KN190==9);

replace unset8=. if unset8==2;

keep HHID PN unset8;
summ;

sort HHID PN;
merge HHID PN using `saved'settle; 
drop _merge;

sort HHID PN; 
sleep 1000; save `saved'settle, replace;


******************************* wave 9 *********************;

use `wave9d'H08A_R;
keep LA028 HHID PN;
sort HHID PN;
sleep 1000; save `saved'temp, replace;

clear;
use `wave9d'H08N_R;
sort HHID PN;
merge HHID PN using `saved'temp;
drop _merge;

gen temp=real(HHID);
drop HHID;
rename temp HHID;
gen temp=real(PN);
drop PN;
rename temp PN;


*****************************;
gen unset9=.;
* note: in the following re-coding, 2 is meant for known missing;


* for hospital stay;
replace unset9=0 if LN099==5|LN099==8;
replace unset9=2 if LN099==9;
replace unset9=0 if LN102==1|LN102==3|LN102==5;
replace unset9=1 if LN102==7;
replace unset9=2 if LN102==8|LN102==9;

* for nursing home stay;
replace unset9=0 if unset9~=1 &  unset9~=2 & (LN114==5|LN114==8); 
replace unset9=2 if unset9~=1 & LN114==9;
replace unset9=0 if unset9~=1 & unset9~=2 & (LN118==1|LN118==3|LN118==5);
replace unset9=1 if LN118==7;
replace unset9=2 if unset9~=1 & (LN118==8|LN118==9);

* for doctor visits;
replace unset9=0 if unset9~=1 &  unset9~=2 & LN147==0; 
replace unset9=0 if unset9~=1 & unset9~=2 & (LN152==1|LN152==3|LN152==5);
replace unset9=1 if LN152==7;
replace unset9=2 if unset9~=1 & (LN152==8|LN152==9);

* for outpatient surgery;
replace unset9=0 if unset9~=1 &  unset9~=2 & (LN134==5|LN134==8); 
replace unset9=2 if unset9~=1 & LN134==9;
replace unset9=0 if unset9~=1 & unset9~=2 & (LN135==1|LN135==3|LN135==5);
replace unset9=1 if LN135==7;
replace unset9=2 if unset9~=1 & (LN135==8|LN135==9);


* for dental care;
replace unset9=0 if unset9~=1 &  unset9~=2 & (LN164==5|LN164==8); 
replace unset9=2 if unset9~=1 & LN164==9;
replace unset9=0 if unset9~=1 & unset9~=2 & (LN165==1|LN165==3|LN165==5);
replace unset9=1 if LN165==8;
replace unset9=2 if unset9~=1 & (LN165==8|LN165==9);

* for prescription medications;
replace unset9=0 if unset9~=1 &  unset9~=2 & (LN175==5|LN175==8); 
replace unset9=2 if unset9~=1 & LN175==9;
replace unset9=0 if unset9~=1 & unset9~=2 & (LN176==1|LN176==3|LN176==5);
replace unset9=1 if LN176==7;
replace unset9=2 if unset9~=1 & (LN176==8|LN176==9);

* for home medical care;
replace unset9=0 if unset9~=1 &  unset9~=2 & LA028==1; * living in nursing home;
replace unset9=0 if unset9~=1 &  unset9~=2 & (LN189==5|LN189==8); 
replace unset9=2 if unset9~=1 & LN189==9;
replace unset9=0 if unset9~=1 & unset9~=2 & (LN190==1|LN190==3|LN190==5);
replace unset9=1 if LN190==7;
replace unset9=2 if unset9~=1 & (LN190==8|LN190==9);

replace unset9=. if unset9==2;

keep HHID PN unset9;
summ;

sort HHID PN;
merge HHID PN using `saved'settle; 
drop _merge;

sort HHID PN; 
sleep 1000; save `saved'settle, replace;


******************************* wave 10 *********************;

use `wave10d'H10A_R;
keep MA028 HHID PN;
sort HHID PN;
sleep 1000; save `saved'temp, replace;

clear;
use `wave10d'H10N_R;
sort HHID PN;
merge HHID PN using `saved'temp;
drop _merge;

gen temp=real(HHID);
drop HHID;
rename temp HHID;
gen temp=real(PN);
drop PN;
rename temp PN;


*****************************;
gen unset10=.;
* note: in the following re-coding, 2 is meant for known missing;


* for hospital stay;
replace unset10=0 if MN099==5|MN099==8;
replace unset10=2 if MN099==9;
replace unset10=0 if MN102==1|MN102==3|MN102==5;
replace unset10=1 if MN102==7;
replace unset10=2 if MN102==8|MN102==9;

* for nursing home stay;
replace unset10=0 if unset10~=1 &  unset10~=2 & (MN114==5|MN114==8); 
replace unset10=2 if unset10~=1 & MN114==9;
replace unset10=0 if unset10~=1 & unset10~=2 & (MN118==1|MN118==3|MN118==5);
replace unset10=1 if MN118==7;
replace unset10=2 if unset10~=1 & (MN118==8|MN118==9);

* for doctor visits;
replace unset10=0 if unset10~=1 &  unset10~=2 & MN147==0; 
replace unset10=0 if unset10~=1 & unset10~=2 & (MN152==1|MN152==3|MN152==5);
replace unset10=1 if MN152==7;
replace unset10=2 if unset10~=1 & (MN152==8|MN152==9);

* for outpatient surgery;
replace unset10=0 if unset10~=1 &  unset10~=2 & (MN134==5|MN134==8); 
replace unset10=2 if unset10~=1 & MN134==9;
replace unset10=0 if unset10~=1 & unset10~=2 & (MN135==1|MN135==3|MN135==5);
replace unset10=1 if MN135==7;
replace unset10=2 if unset10~=1 & (MN135==8|MN135==9);


* for dental care;
replace unset10=0 if unset10~=1 &  unset10~=2 & (MN164==5|MN164==8); 
replace unset10=2 if unset10~=1 & MN164==9;
replace unset10=0 if unset10~=1 & unset10~=2 & (MN165==1|MN165==3|MN165==5);
replace unset10=1 if MN165==8;
replace unset10=2 if unset10~=1 & (MN165==8|MN165==9);

* for prescription medications;
replace unset10=0 if unset10~=1 & unset10~=2 & (MN175==5|MN175==8); 
replace unset10=2 if unset10~=1 & MN175==9;
replace unset10=0 if unset10~=1 & unset10~=2 & (MN176==1|MN176==3|MN176==5);
replace unset10=1 if MN176==7;
replace unset10=2 if unset10~=1 & (MN176==8|MN176==9);

* for home medical care;
replace unset10=0 if unset10~=1 & unset10~=2 & MA028==1; * living in nursing home;
replace unset10=0 if unset10~=1 & unset10~=2 & (MN189==5|MN189==8); 
replace unset10=2 if unset10~=1 & MN189==9;
replace unset10=0 if unset10~=1 & unset10~=2 & (MN190==1|MN190==3|MN190==5);
replace unset10=1 if MN190==7;
replace unset10=2 if unset10~=1 & (MN190==8|MN190==9);

replace unset10=. if unset10==2;

keep HHID PN unset10;
summ;

sort HHID PN;
merge HHID PN using `saved'settle; 
drop _merge;

sort HHID PN; 
sleep 1000; save `saved'settle, replace;









******************************* wave 11 *********************;

use `wave11d'H12A_R;
keep NA028 HHID PN;
sort HHID PN;
sleep 1000; save `saved'temp, replace;

clear;
use `wave11d'H12N_R;
sort HHID PN;
merge HHID PN using `saved'temp;
drop _merge;

gen temp=real(HHID);
drop HHID;
rename temp HHID;
gen temp=real(PN);
drop PN;
rename temp PN;


*****************************;
gen unset11=.;
* note: in the following re-coding, 2 is meant for known missing;


* for hospital stay;
replace unset11=0 if NN099==5|NN099==8;
replace unset11=2 if NN099==9;
replace unset11=0 if NN102==1|NN102==3|NN102==5;
replace unset11=1 if NN102==7;
replace unset11=2 if NN102==8|NN102==9;

* for nursing home stay;
replace unset11=0 if unset11~=1 &  unset11~=2 & (NN114==5|NN114==8); 
replace unset11=2 if unset11~=1 & NN114==9;
replace unset11=0 if unset11~=1 & unset11~=2 & (NN118==1|NN118==3|NN118==5);
replace unset11=1 if NN118==7;
replace unset11=2 if unset11~=1 & (NN118==8|NN118==9);

* for doctor visits;
replace unset11=0 if unset11~=1 &  unset11~=2 & NN147==0; 
replace unset11=0 if unset11~=1 & unset11~=2 & (NN152==1|NN152==3|NN152==5);
replace unset11=1 if NN152==7;
replace unset11=2 if unset11~=1 & (NN152==8|NN152==9);

* for outpatient surgery;
replace unset11=0 if unset11~=1 &  unset11~=2 & (NN134==5|NN134==8); 
replace unset11=2 if unset11~=1 & NN134==9;
replace unset11=0 if unset11~=1 & unset11~=2 & (NN135==1|NN135==3|NN135==5);
replace unset11=1 if NN135==7;
replace unset11=2 if unset11~=1 & (NN135==8|NN135==9);


* for dental care;
replace unset11=0 if unset11~=1 &  unset11~=2 & (NN164==5|NN164==8); 
replace unset11=2 if unset11~=1 & NN164==9;
replace unset11=0 if unset11~=1 & unset11~=2 & (NN165==1|NN165==3|NN165==5);
replace unset11=1 if NN165==8;
replace unset11=2 if unset11~=1 & (NN165==8|NN165==9);

* for prescription medications;
replace unset11=0 if unset11~=1 & unset11~=2 & (NN175==5|NN175==8); 
replace unset11=2 if unset11~=1 & NN175==9;
replace unset11=0 if unset11~=1 & unset11~=2 & (NN176==1|NN176==3|NN176==5);
replace unset11=1 if NN176==7;
replace unset11=2 if unset11~=1 & (NN176==8|NN176==9);

* for home medical care;
replace unset11=0 if unset11~=1 & unset11~=2 & NA028==1; * living in nursing home;
replace unset11=0 if unset11~=1 & unset11~=2 & (NN189==5|NN189==8); 
replace unset11=2 if unset11~=1 & NN189==9;
replace unset11=0 if unset11~=1 & unset11~=2 & (NN190==1|NN190==3|NN190==5);
replace unset11=1 if NN190==7;
replace unset11=2 if unset11~=1 & (NN190==8|NN190==9);

replace unset11=. if unset11==2;

keep HHID PN unset11;
summ;

sort HHID PN;
merge HHID PN using `saved'settle; 
drop _merge;

sort HHID PN; 
sleep 1000; save `saved'settle, replace;


******************************* wave 12 *********************;

use `wave12d'H14A_R;
keep OA028 HHID PN;
sort HHID PN;
sleep 1000; save `saved'temp, replace;

clear;
use `wave12d'H14N_R;
sort HHID PN;
merge HHID PN using `saved'temp;
drop _merge;

gen temp=real(HHID);
drop HHID;
rename temp HHID;
gen temp=real(PN);
drop PN;
rename temp PN;


*****************************;
gen unset12=.;
* note: in the following re-coding, 2 is meant for known missing;


* for hospital stay;
replace unset12=0 if ON099==5|ON099==8;
replace unset12=2 if ON099==9;
*replace unset12=0 if ON102==1|ON102==3|ON102==5;
*replace unset12=1 if ON102==7;
replace unset12=2 if ON433_1==8|ON433_1==9;

* for nursing home stay;
replace unset12=0 if unset12~=1 &  unset12~=2 & (ON114==5|ON114==8); 
replace unset12=2 if unset12~=1 & ON114==9;
*replace unset12=0 if unset12~=1 & unset12~=2 & (ON118==1|ON118==3|ON118==5);
*replace unset12=1 if ON118==7;
replace unset12=2 if unset12~=1 & (ON433_2==8|ON433_2==9);

* for doctor visits;
replace unset12=0 if unset12~=1 &  unset12~=2 & ON147==0; 
*replace unset12=0 if unset12~=1 & unset12~=2 & (ON152==1|ON152==3|ON152==5);
*replace unset12=1 if ON152==7;
replace unset12=2 if unset12~=1 & (ON433_4==8|ON433_4==9);

* for outpatient surgery;
replace unset12=0 if unset12~=1 &  unset12~=2 & (ON134==5|ON134==8); 
replace unset12=2 if unset12~=1 & ON134==9;
*replace unset12=0 if unset12~=1 & unset12~=2 & (ON135==1|ON135==3|ON135==5);
*replace unset12=1 if ON135==7;
replace unset12=2 if unset12~=1 & (ON433_3==8|ON433_3==9);


* for dental care;
replace unset12=0 if unset12~=1 &  unset12~=2 & (ON164==5|ON164==8); 
replace unset12=2 if unset12~=1 & ON164==9;
*replace unset12=0 if unset12~=1 & unset12~=2 & (ON165==1|ON165==3|ON165==5);
*replace unset12=1 if ON165==8;
replace unset12=2 if unset12~=1 & (ON433_5==8|ON433_5==9);

* for prescription medications;
replace unset12=0 if unset12~=1 & unset12~=2 & (ON175==5|ON175==8); 
replace unset12=2 if unset12~=1 & ON175==9;
*replace unset12=0 if unset12~=1 & unset12~=2 & (ON176==1|ON176==3|ON176==5);
*replace unset12=1 if ON176==7;
replace unset12=2 if unset12~=1 & (ON433_6==8|ON433_6==9);

* for home medical care;
replace unset12=0 if unset12~=1 & unset12~=2 & OA028==1; //* living in nursing home;
replace unset12=0 if unset12~=1 & unset12~=2 & (ON189==5|ON189==8); 
replace unset12=2 if unset12~=1 & ON189==9;
*replace unset12=0 if unset12~=1 & unset12~=2 & (ON190==1|ON190==3|ON190==5);
*replace unset12=1 if ON190==7;
replace unset12=2 if unset12~=1 & (ON433_7==8|ON433_7==9);

replace unset12=. if unset12==2;
replace unset12=.;

keep HHID PN unset12;
summ;

sort HHID PN;
merge HHID PN using `saved'settle; 
drop _merge;

sort HHID PN; 
sleep 1000; save `saved'settle, replace;




******************************* wave 13 *********************;

use `wave13d'H16A_R;
keep PA028 HHID PN;
sort HHID PN;
sleep 1000; save `saved'temp, replace;

clear;
use `wave13d'H16N_R;
sort HHID PN;
merge HHID PN using `saved'temp;
drop _merge;

gen temp=real(HHID);
drop HHID;
rename temp HHID;
gen temp=real(PN);
drop PN;
rename temp PN;


*****************************;
gen unset13=.;
* note: in the following re-coding, 2 is meant for known missing;


* for hospital stay;
replace unset13=0 if PN099==5|PN099==8;
replace unset13=2 if PN099==9;
*replace unset13=0 if PN102==1|PN102==3|PN102==5;
*replace unset13=1 if PN102==7;
replace unset13=2 if PN433_1==8|PN433_1==9;

* for nursing home stay;
replace unset13=0 if unset13~=1 &  unset13~=2 & (PN114==5|PN114==8); 
replace unset13=2 if unset13~=1 & PN114==9;
*replace unset13=0 if unset13~=1 & unset13~=2 & (PN118==1|PN118==3|PN118==5);
*replace unset13=1 if PN118==7;
replace unset13=2 if unset13~=1 & (PN433_2==8|PN433_2==9);

* for doctor visits;
replace unset13=0 if unset13~=1 &  unset13~=2 & PN147==0; 
*replace unset13=0 if unset13~=1 & unset13~=2 & (PN152==1|PN152==3|PN152==5);
*replace unset13=1 if PN152==7;
replace unset13=2 if unset13~=1 & (PN433_4==8|PN433_4==9);

* for outpatient surgery;
replace unset13=0 if unset13~=1 &  unset13~=2 & (PN134==5|PN134==8); 
replace unset13=2 if unset13~=1 & PN134==9;
*replace unset13=0 if unset13~=1 & unset13~=2 & (PN135==1|PN135==3|PN135==5);
*replace unset13=1 if PN135==7;
replace unset13=2 if unset13~=1 & (PN433_3==8|PN433_3==9);


* for dental care;
replace unset13=0 if unset13~=1 &  unset13~=2 & (PN164==5|PN164==8); 
replace unset13=2 if unset13~=1 & PN164==9;
*replace unset13=0 if unset13~=1 & unset13~=2 & (PN165==1|PN165==3|PN165==5);
*replace unset13=1 if PN165==8;
replace unset13=2 if unset13~=1 & (PN433_5==8|PN433_5==9);

* for prescription medications;
replace unset13=0 if unset13~=1 & unset13~=2 & (PN175==5|PN175==8); 
replace unset13=2 if unset13~=1 & PN175==9;
*replace unset13=0 if unset13~=1 & unset13~=2 & (PN176==1|PN176==3|PN176==5);
*replace unset13=1 if PN176==7;
replace unset13=2 if unset13~=1 & (PN433_6==8|PN433_6==9);

* for home medical care;
replace unset13=0 if unset13~=1 & unset13~=2 & PA028==1; * living in nursing home;
replace unset13=0 if unset13~=1 & unset13~=2 & (PN189==5|PN189==8); 
replace unset13=2 if unset13~=1 & PN189==9;
*replace unset13=0 if unset13~=1 & unset13~=2 & (PN190==1|PN190==3|PN190==5);
*replace unset13=1 if PN190==7;
replace unset13=2 if unset13~=1 & (PN433_7==8|PN433_7==9);

replace unset13=. if unset13==2;
replace unset13=.;

keep HHID PN unset13;
summ;

sort HHID PN;
merge HHID PN using `saved'settle; 
drop _merge;

sort HHID PN; 
sleep 1000; save `saved'settle, replace;
******************************* end wave 13 *********************;


******************************* wave 14 *********************;

use `wave14d'H18A_R;
rename hhid HHID;
rename pn PN;
keep QA028 HHID PN;
sort HHID PN;
sleep 1000; save `saved'temp, replace;

clear;
use `wave14d'H18N_R;
rename hhid HHID;
rename pn PN;
sort HHID PN;
merge HHID PN using `saved'temp;
drop _merge;

gen temp=real(HHID);
drop HHID;
rename temp HHID;
gen temp=real(PN);
drop PN;
rename temp PN;


*****************************;
gen unset14=.;
* note: in the following re-coding, 2 is meant for known missing;


* for hospital stay;
replace unset14=0 if QN099==5|QN099==8;
replace unset14=2 if QN099==9;
*replace unset14=0 if QN102==1|QN102==3|QN102==5;
*replace unset14=1 if QN102==7;
replace unset14=2 if QN433_1==8|QN433_1==9;

* for nursing home stay;
replace unset14=0 if unset14~=1 &  unset14~=2 & (QN114==5|QN114==8); 
replace unset14=2 if unset14~=1 & QN114==9;
*replace unset14=0 if unset14~=1 & unset14~=2 & (QN118==1|QN118==3|QN118==5);
*replace unset14=1 if QN118==7;
replace unset14=2 if unset14~=1 & (QN433_2==8|QN433_2==9);

* for doctor visits;
replace unset14=0 if unset14~=1 &  unset14~=2 & QN147==0; 
*replace unset14=0 if unset14~=1 & unset14~=2 & (QN152==1|QN152==3|QN152==5);
*replace unset14=1 if QN152==7;
replace unset14=2 if unset14~=1 & (QN433_4==8|QN433_4==9);

* for outpatient surgery;
replace unset14=0 if unset14~=1 &  unset14~=2 & (QN134==5|QN134==8); 
replace unset14=2 if unset14~=1 & QN134==9;
*replace unset14=0 if unset14~=1 & unset14~=2 & (QN145==1|QN145==3|QN145==5);
*replace unset14=1 if QN145==7;
replace unset14=2 if unset14~=1 & (QN433_3==8|QN433_3==9);


* for dental care;
replace unset14=0 if unset14~=1 &  unset14~=2 & (QN164==5|QN164==8); 
replace unset14=2 if unset14~=1 & QN164==9;
*replace unset14=0 if unset14~=1 & unset14~=2 & (QN165==1|QN165==3|QN165==5);
*replace unset14=1 if QN165==8;
replace unset14=2 if unset14~=1 & (QN433_5==8|QN433_5==9);

* for prescription medications;
replace unset14=0 if unset14~=1 & unset14~=2 & (QN175==5|QN175==8); 
replace unset14=2 if unset14~=1 & QN175==9;
*replace unset14=0 if unset14~=1 & unset14~=2 & (QN176==1|QN176==3|QN176==5);
*replace unset14=1 if QN176==7;
replace unset14=2 if unset14~=1 & (QN433_6==8|QN433_6==9);

* for home medical care;
replace unset14=0 if unset14~=1 & unset14~=2 & QA028==1; * living in nursing home;
replace unset14=0 if unset14~=1 & unset14~=2 & (QN189==5|QN189==8); 
replace unset14=2 if unset14~=1 & QN189==9;
*replace unset14=0 if unset14~=1 & unset14~=2 & (QN190==1|QN190==3|QN190==5);
*replace unset14=1 if QN190==7;
replace unset14=2 if unset14~=1 & (QN433_7==8|QN433_7==9);

replace unset14=. if unset14==2;
replace unset14=.;

keep HHID PN unset14;
summ;

sort HHID PN;
merge HHID PN using `saved'settle; 
drop _merge;

sort HHID PN; 
sleep 1000; save `saved'settle, replace;
******************************* end wave 14 *********************;

******************************* wave 15 *********************;
if $INCLUDE2020 {; 
use `wave15d'H20A_R;
rename hhid HHID;
rename pn PN;
keep RA028 HHID PN;
sort HHID PN;
sleep 1000; save `saved'temp, replace;

clear;
use `wave15d'H20N_R;
rename hhid HHID;
rename pn PN;
sort HHID PN;
merge HHID PN using `saved'temp;
drop _merge;

gen temp=real(HHID);
drop HHID;
rename temp HHID;
gen temp=real(PN);
drop PN;
rename temp PN;


*****************************;
gen unset15=.;
* note: in the following re-coding, 2 is meant for known missing;


* for hospital stay;
replace unset15=0 if RN099==5|RN099==8;
replace unset15=2 if RN099==9;
*replace unset15=0 if RN102==1|RN102==3|RN102==5;
*replace unset15=1 if RN102==7;
replace unset15=2 if RN433_1==8|RN433_1==9;

* for nursing home stay;
replace unset15=0 if unset15~=1 &  unset15~=2 & (RN114==5|RN114==8); 
replace unset15=2 if unset15~=1 & RN114==9;
*replace unset15=0 if unset15~=1 & unset15~=2 & (RN118==1|RN118==3|RN118==5);
*replace unset15=1 if RN118==7;
replace unset15=2 if unset15~=1 & (RN433_2==8|RN433_2==9);

* for doctor visits;
replace unset15=0 if unset15~=1 &  unset15~=2 & RN147==0; 
*replace unset15=0 if unset15~=1 & unset15~=2 & (RN152==1|RN152==3|RN152==5);
*replace unset15=1 if RN152==7;
replace unset15=2 if unset15~=1 & (RN433_4==8|RN433_4==9);

* for outpatient surgery;
replace unset15=0 if unset15~=1 &  unset15~=2 & (RN134==5|RN134==8); 
replace unset15=2 if unset15~=1 & RN134==9;
*replace unset15=0 if unset15~=1 & unset15~=2 & (RN155==1|RN155==3|RN155==5);
*replace unset15=1 if RN155==7;
replace unset15=2 if unset15~=1 & (RN433_3==8|RN433_3==9);


* for dental care;
replace unset15=0 if unset15~=1 &  unset15~=2 & (RN164==5|RN164==8); 
replace unset15=2 if unset15~=1 & RN164==9;
*replace unset15=0 if unset15~=1 & unset15~=2 & (RN165==1|RN165==3|RN165==5);
*replace unset15=1 if RN165==8;
replace unset15=2 if unset15~=1 & (RN433_5==8|RN433_5==9);

* for prescription medications;
replace unset15=0 if unset15~=1 & unset15~=2 & (RN175==5|RN175==8); 
replace unset15=2 if unset15~=1 & RN175==9;
*replace unset15=0 if unset15~=1 & unset15~=2 & (RN176==1|RN176==3|RN176==5);
*replace unset15=1 if RN176==7;
replace unset15=2 if unset15~=1 & (RN433_6==8|RN433_6==9);

* for home medical care;
replace unset15=0 if unset15~=1 & unset15~=2 & RA028==1; * living in nursing home;
replace unset15=0 if unset15~=1 & unset15~=2 & (RN189==5|RN189==8); 
replace unset15=2 if unset15~=1 & RN189==9;
*replace unset15=0 if unset15~=1 & unset15~=2 & (RN190==1|RN190==3|RN190==5);
*replace unset15=1 if RN190==7;
replace unset15=2 if unset15~=1 & (RN433_7==8|RN433_7==9);

replace unset15=. if unset15==2;
replace unset15=.;

keep HHID PN unset15;
summ;

sort HHID PN;
merge HHID PN using `saved'settle; 
drop _merge;

sort HHID PN; 
sleep 1000; save `saved'settle, replace;
};
******************************* end wave 15 *********************;








************************  ahead wave 1 *************************;


*** NOTE THAT bhh21 is HOUSEHOLD LEVEL *****;
clear;
set mem 200m;
use `aheadw1'bhh21;
sort HHID BSUBHH;
save `aheadw1'temp, replace;

clear;
set mem 200m;
use `aheadw1'br21;
sort HHID BSUBHH;
merge HHID BSUBHH using `aheadw1'temp;
drop _merge;



**********************************************;
* note: ahead wave 1 data is very different from those of other waves, because the data for this wave is at household level;

gen unset1=.;
* note: in the following re-coding, we are not able to differentiate between DK, RF and NA/INA;


* for hospital stay;
replace unset1=0 if V605==5;
replace unset1=2 if V605==.;
replace unset1=0 if V610==1|V610==3|V610==5;
replace unset1=1 if V610==7;
* replace unset1=2 if V610==8|V610==9;

* for nursing home stay;
replace unset1=0 if unset1~=1 &  unset1~=2 & V622==5; 
* replace unset1=2 if unset1~=1 & V622==9;
replace unset1=0 if unset1~=1 & unset1~=2 & (V627==1|V627==5);
replace unset1=1 if V627==7;
* replace unset1=2 if unset1~=1 & (V627==8|V627==9);

* for doctor visits;
replace unset1=0 if unset1~=1 &  unset1~=2 & V639==5; 
*  replace unset1=2 if unset1~=1 & V639==9;
replace unset1=0 if unset1~=1 & unset1~=2 & (V642==1|V642==5);
replace unset1=1 if V642==7;
* replace unset1=2 if unset1~=1 & (V642==8|V642==9);

* for outpatient surgery;
replace unset1=0 if unset1~=1 &  unset1~=2 & V654==5; 
* replace unset1=2 if unset1~=1 & V654==9;
replace unset1=0 if unset1~=1 & unset1~=2 & (V657==1|V657==5);
replace unset1=1 if V657==7;
* replace unset1=2 if unset1~=1 & (V657==8|V657==9);


* for dental care;
replace unset1=0 if unset1~=1 &  unset1~=2 & V669==5; 
* replace unset1=2 if unset1~=1 & V669==9;
replace unset1=0 if unset1~=1 & unset1~=2 & (V672==1|V672==5);
replace unset1=1 if V672==7;
* replace unset1=2 if unset1~=1 & (V672==8|V672==9);

* for prescription medications;
replace unset1=0 if unset1~=1 &  unset1~=2 & V685==5; 
* replace unset1=2 if unset1~=1 & V685==9;
replace unset1=0 if unset1~=1 & unset1~=2 & (V689==1|V689==5);
replace unset1=1 if V689==7;
* replace unset1=2 if unset1~=1 & (V689==8|V689==9);

* for home medical care;
replace unset1=0 if unset1~=1 &  unset1~=2 & V701==5; 
* replace unset1=2 if unset1~=1 & V701==9;
replace unset1=0 if unset1~=1 & unset1~=2 & (V703==1|V703==5);
replace unset1=1 if V703==7;
* replace unset1=2 if unset1~=1 & (V703==8|V703==9);

replace unset1=. if unset1==2;
replace unset1=0 if unset1==.;

keep HHID PN unset1;
summ;

sort HHID PN;
save `aheadw1'temp, replace;



**************************** ahead wave 2 ***************************;

use `aheadw2'A95CS_R; * get some CS variable from this file; * Used to be ahd2cs;
gen temp=real(HHID); 
drop HHID; 
rename temp HHID; 
gen temp=real(PN); 
drop PN; 
rename temp PN; 

sort HHID PN;
keep HHID PN D240;

save `aheadw2'temp, replace;

clear;
set memory 200m;
use `aheadw2'A95E_R; *Used to be ahd2e;
gen temp=real(HHID); 
drop HHID; 
rename temp HHID; 
gen temp=real(PN); 
drop PN; 
rename temp PN; 
sort HHID PN;
merge HHID PN using `aheadw2'temp;
drop _merge;


sort HHID PN;

*****************************;
gen unset2=.;
* note: in the following re-coding, 2 is meant for known missing;


* for hospital stay;
replace unset2=0 if D1664==5|D1664==8;
replace unset2=2 if D1664==9;
replace unset2=0 if D1669==1|D1669==3|D1669==5;
replace unset2=1 if D1669==7;
replace unset2=2 if D1669==8|D1669==9;

* for nursing home stay;
replace unset2=0 if unset2~=1 &  unset2~=2 & (D1681==5|D1681==8); 
replace unset2=2 if unset2~=1 & D1681==9;
replace unset2=0 if unset2~=1 & unset2~=2 & (D1686==1|D1686==3|D1686==5);
replace unset2=1 if D1686==7;
replace unset2=2 if unset2~=1 & (D1686==8|D1686==9);

* for doctor visits;
replace unset2=0 if unset2~=1 & unset2~=2 & D1698==0; 
replace unset2=2 if unset2~=1 & (D1698==998|D1698==999);
replace unset2=0 if unset2~=1 & unset2~=2 & (D1701==1|D1701==3|D1701==5);
replace unset2=1 if D1701==7;
replace unset2=2 if unset2~=1 & (D1701==8|D1701==9);

* for outpatient surgery;
replace unset2=0 if unset2~=1 & unset2~=2 & (D1713==5|D1713==8); 
replace unset2=2 if unset2~=1 & D1713==9;
replace unset2=0 if unset2~=1 & unset2~=2 & (D1716==1|D1716==3|D1716==5);
replace unset2=1 if D1716==7;
replace unset2=2 if unset2~=1 & (D1716==8|D1716==9);


* for dental care;
replace unset2=0 if unset2~=1 & unset2~=2 & (D1728==5|D1728==8); 
replace unset2=2 if unset2~=1 & D1728==9;
replace unset2=0 if unset2~=1 & unset2~=2 & (D1731==1|D1731==3|D1731==5);
replace unset2=1 if D1731==7;
replace unset2=2 if unset2~=1 & (D1731==8|D1731==9);

* for prescription medications;
replace unset2=0 if unset2~=1 & unset2~=2 & (D1744==5|D1744==8); 
replace unset2=2 if unset2~=1 & D1744==9;
replace unset2=0 if unset2~=1 & unset2~=2 & (D1748==1|D1748==3|D1748==5);
replace unset2=1 if D1748==7;
replace unset2=2 if unset2~=1 & (D1748==8|D1748==9);

* for home medical care;
replace unset2=0 if unset2~=1 & unset2~=2 & D240==1; * living in nursing home;
replace unset2=0 if unset2~=1 & unset2~=2 & (D1760==5|D1760==8); 
replace unset2=2 if unset2~=1 & D1760==9;
replace unset2=0 if unset2~=1 & unset2~=2 & (D1762==1|D1762==3|D1762==5);
replace unset2=1 if D1762==7;
replace unset2=2 if unset2~=1 & (D1762==8|D1762==9);

replace unset2=. if unset2==2;

keep HHID PN unset2;
summ;

sort HHID PN;
save `aheadw2'temp, replace;

clear;
set mem 200m;
use `aheadw1'temp;
gen temp=real(HHID); 
drop HHID; 
rename temp HHID; 
gen temp=real(PN); 
drop PN; 
rename temp PN; 
sort HHID PN; 
sort HHID PN;
merge HHID PN using `aheadw2'temp;
drop _merge;


* rename AHEAD variables for merging;
rename unset1 aunset1;
rename unset2 aunset2;

sort HHID PN;
merge HHID PN using `saved'settle; 
drop _merge;

* replace missing HRS WAVE I and WAVE II values with AHEAD WAVE I and WAVE II 
values;
replace unset1=aunset1 if unset1==. & aunset1~=.;
replace unset2=aunset2 if unset2==. & aunset2~=.;

drop a*; * drop AHEAD variables;


replace unset12=.;

summ;

sort HHID PN; 
sleep 1000; save `saved'settle, replace;


cap log close

* compare summary stats before and after;
cd "$folder\hrs\merge\compare\" ;
summtab, contvars(_all) mean median range excel excelname(settle.xlsx) replace;
cd "$folder\hrs\merge\" ;
use `saved'settle.old.dta , clear;
cd "$folder\hrs\merge\compare\" ;
summtab, contvars(_all) mean median range excel excelname(settle.xlsx) sheetname(Old);








